    #!/usr/bin/env bash
    set -euo pipefail

    # UTC timestamp for this run
    TS="$(python3 - <<'PY'
from datetime import datetime, timezone
print(datetime.now(timezone.utc).strftime('%Y-%m-%dT%H-%M-%SZ'))
PY
)"
    echo "Run timestamp: $TS"

    # Prepare workspace
    mkdir -p "G18_recentering_v2/$TS/config"
    cp -f "config/manifest_g18_v2.json" "G18_recentering_v2/$TS/config/manifest_g18_v2.json"

    # Execute
    python3 engine_g18_recentering_v2.py \
      --manifest "G18_recentering_v2/$TS/config/manifest_g18_v2.json" \
      --outdir   "G18_recentering_v2/$TS/"

    echo ""
    echo "Result line:"
    cat "G18_recentering_v2/$TS/outputs/run_info/result_line.txt"
    echo ""
    echo "Artifacts:"
    echo "  metrics:  G18_recentering_v2/$TS/outputs/metrics/g18_pair_metrics.csv"
    echo "  audit:    G18_recentering_v2/$TS/outputs/audits/g18_audit.json"
    echo "  run info: G18_recentering_v2/$TS/outputs/run_info/result_line.txt"
